<?php
session_start();
require_once '../config/database.php';

header('Content-Type: application/json');

if (!is_admin()) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

if (isset($_POST['path'])) {
    $path = $_POST['path'];
    $fullPath = dirname(__DIR__) . $path;
    
    if (file_exists($fullPath) && unlink($fullPath)) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to delete file']);
    }
    exit;
}

echo json_encode(['success' => false, 'message' => 'No file specified']); 